#!/bin/bash
# provide all netdevs for conky
# ${wireless_mode wlan0} : ${wireless_bitrate wlan0} : ${wireless_link_qual_perc wlan0}%  " : ""% "'"ESSID: "'
cd $PWD
rm -f /tmp/netdev.txt
rm -f /tmp/NETDEV.txt
touch /tmp/NETDEV.txt

nonif=$(echo `cat /proc/net/route | grep -i "eth\|wlan"`)
if [ -z "$nonif" ]; then
echo "NoNetIf" > /tmp/netdev.txt
else
ifconfig -s | grep -i "eth\|wlan" | sed s/" "/"#"/g | cut -d# -f1 | sort > /tmp/netdev.txt
fi

while read f
do

case $f in
eth[0-9])
	echo "active: $f			Up	|   Down " >> /tmp/NETDEV.txt 
	echo "Local-IP: "'${addr '$f'}'"	"'${upspeed '$f'}'"/s	|   "'${downspeed '$f'}'"/s " >> /tmp/NETDEV.txt
	;;
wlan[0-9])
	echo "active: $f			Up	|   Down " >> /tmp/NETDEV.txt
	echo "Wlan-IP:  "'${addr '$f'}'"	"'${upspeed '$f'}'"/s	|   "'${downspeed '$f'}'"/s " >> /tmp/NETDEV.txt
	echo '${wireless_essid '$f'}'":	"'${wireless_mode '$f'}'": "'${wireless_bitrate '$f'}'" : "'${wireless_link_qual_perc '$f'}%' >> /tmp/NETDEV.txt
	;;
NoNetIf)
	echo "Not setup Networkinterface" >> /tmp/NETDEV.txt
	;;
*)
	echo "error" >> /tmp/NETDEV.txt
	;;
esac

done < /tmp/netdev.txt

cat /tmp/NETDEV.txt

exit 0
